/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.event;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.ByteArray;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.p.pa.domain.RioTopologyReader;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import com.ibm.hwmca.xfw.panel.CaptionValuePairing;
import com.ibm.hwmca.xfw.panel.LocalizablePanelValue;
import com.ibm.hwmca.xfw.panel.NonLocalizablePanelValue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class SaelDataEvent
extends DistributedDataEvent {
    private static final String TRACE_MASKT = "PPASDEVT";
    private static final String TRACE_MASKF = "PPASDEVF";
    private static final String TRACE_MASKD = "PPASDEVD";
    protected int slid = 0;
    protected String version = "";
    protected String creatorID = "";
    protected String partitionOSType = "";
    protected PASystem clusterSystem = null;
    protected String hpsNetworkID = "";
    protected String aixErrorCode = "";
    protected String partitionID = "";
    protected String partitionName = "";
    protected String partitionHostName = "";
    protected String saelFirstReportedTime = "";
    protected String lastSubsystemReportedTime = "";
    protected int duplicateCount = 0;
    protected String eed = "";
    protected long calledHome = 0L;
    protected long variety = 0L;
    protected int numFixPacks = 0;
    protected String[] fixPacArray;
    protected String pmh;
    protected String symptomString = "";
    protected String errorLogLabel = "";
    protected String saelNotificationType = "";
    protected int numLocationCodes = 0;
    protected String[] locationCodes = new String[]{""};
    protected int numCecsMT = 0;
    protected String[] cecMT = new String[]{""};
    protected int numCecsMS = 0;
    protected String[] cecMS = new String[]{""};
    protected String devMT = "";
    protected String devMS = "";
    protected long seqNum = 0L;
    protected int numClusters = 0;
    protected String[] clusterList = new String[]{""};
    protected boolean parsed = false;
    protected int totalLength = 0;
    public static String SRN_SPEC1 = "A25-001";

    public SaelDataEvent(Object source) {
        super(source);
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.setPriority(40.0f);
    }

    public SaelDataEvent(Object source, String evtId) {
        super(source, evtId);
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.setPriority(40.0f);
    }

    protected void parseData() throws HException {
        Trace.trace(TRACE_MASKD, "--> SaelDataEvent.parseData()");
        Trace.trace(TRACE_MASKD, this.logData);
        if (!this.parsed) {
            Trace.trace(TRACE_MASKD, "data not previously parsed");
            this.parsed = true;
            int parsePoint = 0;
            if (this.logData[parsePoint] != -1) {
                throw new HException("the first byte wasn't 0xff");
            }
            this.setTotalLength((int)ByteArray.extractU32(this.logData, ++parsePoint, true));
            Trace.trace(TRACE_MASKD, "totalLength =" + this.getTotalLength());
            this.saelNotificationType = ByteArray.extractNullString(this.logData, parsePoint += 4);
            parsePoint += this.saelNotificationType.length() + 1;
            this.saelNotificationType = this.saelNotificationType.trim();
            if (this.saelNotificationType.equals("Yes")) {
                this.setNotificationType(new BaseMessageText("XPA7800"));
            } else {
                this.setNotificationType(new BaseMessageText("XPA7801"));
            }
            this.calledHome = ByteArray.extractU32(this.logData, parsePoint, true);
            this.variety = ByteArray.extractU32(this.logData, parsePoint += 4, true);
            this.setPlatformLogID((int)ByteArray.extractU32(this.logData, parsePoint += 4, true));
            this.slid = this.getPlatformLogID();
            this.creatorID = ByteArray.extractNullString(this.logData, parsePoint += 4);
            this.creatorID = this.creatorID.trim();
            this.setSubsystemID((int)ByteArray.extractU32(this.logData, parsePoint += this.creatorID.length() + 1, true));
            int ssid = this.getSubsystemID();
            this.priority = ssid > 0 && ssid <= 15 ? 10.0f : (ssid >= 16 && ssid <= 31 ? 60.0f : (ssid >= 32 && ssid <= 47 ? 70.0f : (ssid >= 48 && ssid <= 63 ? 50.0f : (ssid >= 64 && ssid <= 79 ? 45.0f : (ssid >= 80 && ssid <= 95 ? 65.0f : (ssid >= 96 && ssid <= 111 ? 90.0f : (ssid >= 112 && ssid <= 121 ? 26.0f : (ssid >= 122 && ssid <= 127 ? 30.0f : (ssid >= 128 && ssid <= 143 ? 25.0f : (ssid >= 144 && ssid <= 159 ? 20.0f : (ssid >= 160 && ssid <= 175 ? 80.0f : 10.0f)))))))))));
            this.setRefcode(ByteArray.extractNullString(this.logData, parsePoint += 4));
            this.setRefcode(this.getRefcode().trim());
            Trace.trace(TRACE_MASKD, "refcode is" + this.getRefcode());
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += this.refcode.length() + 1));
            this.setEventSeverity((int)ByteArray.extractU32(this.logData, parsePoint, true));
            Trace.trace(TRACE_MASKD, "eventSeverity " + this.getEventSeverity());
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += 4));
            this.numFixPacks = (int)ByteArray.extractU32(this.logData, parsePoint, true);
            Trace.trace(TRACE_MASKD, "numFixPacks " + this.numFixPacks);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += 4));
            if (this.numFixPacks + parsePoint > this.getTotalLength()) {
                Trace.trace(TRACE_MASKD, "numNumFixPacks will blow past our length return ");
                return;
            }
            this.fixPacArray = new String[this.numFixPacks];
            int len = this.getStringArray(this.logData, parsePoint, this.fixPacArray);
            Trace.trace(TRACE_MASKD, "after nested fix packs " + (parsePoint += len));
            Trace.trace(TRACE_MASKD, "parsePoint is " + parsePoint);
            this.pmh = ByteArray.extractNullString(this.logData, parsePoint);
            Trace.trace(TRACE_MASKD, "pmh is " + this.pmh);
            this.pmh = this.pmh.trim();
            int fruCount = (int)ByteArray.extractU32(this.logData, parsePoint += this.pmh.length() + 1, true);
            len = this.parseFruData(fruCount, parsePoint += 4);
            if (len < 0) {
                Trace.trace(TRACE_MASKT, "parseFruData indicates a format error continue with what we have ");
                return;
            }
            Trace.trace(TRACE_MASKD, "after fru parsing");
            Trace.trace(TRACE_MASKD, "parsePoint = " + (parsePoint += len));
            int nodeCount = (int)ByteArray.extractU32(this.logData, parsePoint, true);
            if (nodeCount + (parsePoint += 4) > this.getTotalLength()) {
                Trace.trace(TRACE_MASKD, "nodeCount + parsePoint is greater than our length end it now");
                return;
            }
            len = this.parseNodeData(nodeCount, parsePoint);
            if (len < 0) {
                Trace.trace(TRACE_MASKT, "paseNodeData indicates a format error; abandon ship");
                return;
            }
            this.symptomString = ByteArray.extractNullString(this.logData, parsePoint += len);
            Trace.trace(TRACE_MASKD, "the symptom string is " + this.symptomString);
            this.symptomString = this.symptomString.trim();
            if ((parsePoint += this.symptomString.length() + 1) < this.getTotalLength()) {
                this.setErrorLogLabel(ByteArray.extractNullString(this.logData, parsePoint));
                Trace.trace(TRACE_MASKD, "errorLogLabel " + this.getErrorLogLabel());
            } else {
                Trace.trace(TRACE_MASKD, "we were at the end there was no errorLogId " + this.symptomString);
            }
            this.setDataId(new Integer(this.getPlatformLogID()).toString() + "//" + new Integer(this.getSystemLogId()).toString());
            if (this.getRefcode() == null || this.getRefcode().trim().equals("") && !this.getAIXErrorCode().equals("")) {
                Trace.trace(TRACE_MASKD, "place aixErrorCode(SRN) in for refcode" + this.getAIXErrorCode());
                this.setRefcode(this.getAIXErrorCode());
            }
        } else {
            Trace.trace(TRACE_MASKD, "data has already been parsed. Just skip it");
        }
        Trace.trace(TRACE_MASKD, "<-- SaelDataEvent.parseData()");
    }

    protected DomainIdentifier determineDomain() throws HException {
        DomainIdentifier domainId = null;
        if (this.isRioError()) {
            String idString = null;
            String rioMTMS = null;
            String loopId = this.getRioLoopId();
            if (this.getFailingEnclosureSystem() != null) {
                rioMTMS = this.getFailingEnclosureSystem().getMTMS();
                Trace.trace(TRACE_MASKF, "setting rio loop to be [" + rioMTMS + loopId + "]");
                idString = RioTopologyReader.getRioDomainForLoop(rioMTMS, loopId);
            }
            if (idString == null && this.getReportingSystem() != null) {
                rioMTMS = this.getReportingSystem().getMTMS();
                Trace.trace(TRACE_MASKF, "setting rio loop to be [" + rioMTMS + loopId + "]");
                idString = RioTopologyReader.getRioDomainForLoop(rioMTMS, loopId);
            }
            if (idString == null) {
                HMC hmc = HMC.getHMC();
                idString = "RIO DEFAULT" + hmc.getMachineModel() + hmc.getMachineType() + hmc.getMachineSerial();
            }
            domainId = new DomainIdentifier(idString);
        } else if (this.isSurveillanceError()) {
            domainId = new DomainIdentifier("LSAD");
        } else {
            DistributedAnalysisDomain dummyDad = null;
            try {
                dummyDad = (DistributedAnalysisDomain)Class.forName("com.ibm.hsc.ccfw.pa.domain.PowerAnalysisDomain").newInstance();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "Exception building power domain instance");
                Trace.trace(TRACE_MASKT, e);
                throw new HException("Exception building power domain instance");
            }
            DistributedAnalysisDomain realDad = dummyDad.getDomain(this.getFailingEnclosureSystem().getMTMS());
            if (realDad == null) {
                realDad = dummyDad.getDomain(this.getReportingSystem().getMTMS());
            }
            if (realDad != null) {
                domainId = realDad.getDomainId();
            }
        }
        if (domainId == null) {
            Trace.trace(TRACE_MASKT, "Could not determine domain for event");
            throw new HException("Could not determine domain for event");
        }
        Trace.trace(TRACE_MASKF, "<-> determineDomain: " + domainId.getDID());
        return domainId;
    }

    protected PASystem deriveSystem() {
        int charAt;
        Trace.trace(TRACE_MASKD, "--> deriveSystem");
        try {
            this.parseData();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got a parse exception");
            Trace.trace(TRACE_MASKF, e);
            this.parsed = false;
            this.fruList = new XMLEncodeableArrayList();
        }
        Trace.trace(TRACE_MASKD, "keo pull out the mtms info for the system this belongs to");
        String machineType = "type";
        String machineModel = "model";
        String machineSerial = "serial";
        if (!this.devMT.equals("")) {
            Trace.trace(TRACE_MASKD, "the devMT is " + this.devMT);
            Trace.trace(TRACE_MASKD, "the devMS is " + this.devMS);
            charAt = this.devMT.indexOf("-");
            if (charAt == -1) {
                machineType = this.devMT;
                machineModel = "Model";
            } else {
                machineType = this.devMT.substring(0, charAt);
                machineModel = this.devMT.substring(charAt + 1);
            }
            machineSerial = this.devMS;
        } else {
            Trace.trace(TRACE_MASKD, "the cecMT[0] is " + this.cecMT[0]);
            Trace.trace(TRACE_MASKD, "the cecMS[0] is " + this.cecMS[0]);
            charAt = this.cecMT[0].indexOf("-");
            if (charAt == -1) {
                machineType = this.devMT;
                machineModel = "Model";
            } else {
                machineType = this.cecMT[0].substring(0, charAt);
                machineModel = this.cecMT[0].substring(charAt + 1);
            }
            machineSerial = this.cecMS[0];
        }
        Trace.trace(TRACE_MASKF, "building a system for machine type [" + machineType + "]" + " machine model [" + machineModel + "]" + " machine serial [" + machineSerial + "]");
        RemoteSystem theSystem = new RemoteMachineSystem(machineType, machineModel, machineSerial);
        RemoteSystemManager rsm = RemoteSystemManager.getRemoteSystemManager();
        if (rsm != null) {
            RemoteSystem knownSys = rsm.getKnownSystem(theSystem);
            if (knownSys != null) {
                Trace.trace(TRACE_MASKD, "Associating system with RemoteSystemManager reference [" + knownSys.getUniqueKey() + "]");
                theSystem = knownSys;
            } else {
                Trace.trace(TRACE_MASKT, "Not a known RemoteSystemManager-controlled system.  Should it be?");
            }
        }
        this.setFailingEnclosureSystem(theSystem);
        this.addAssociatedSystem(theSystem);
        try {
            this.setDomainId(this.determineDomain());
        }
        catch (HException e1) {
            e1.printStackTrace();
            Trace.trace(TRACE_MASKT, "exception determining the domain");
        }
        Trace.trace(TRACE_MASKD, "<-- deriveSystem");
        return theSystem;
    }

    public int getStringArray(byte[] data, int offset, String[] output) {
        Trace.trace(TRACE_MASKD, "-> getStringArray");
        Trace.trace(TRACE_MASKD, "offset " + offset);
        int bytesProcessed = 0;
        for (int i = 0; i < output.length; ++i) {
            Trace.trace(TRACE_MASKD, "loop " + i);
            String dataElement = ByteArray.extractNullString(data, bytesProcessed + offset);
            Trace.trace(TRACE_MASKD, "dataElement " + dataElement);
            bytesProcessed += dataElement.length() + 1;
            output[i] = dataElement = dataElement.trim();
            Trace.trace(TRACE_MASKD, "bytesProcessed " + bytesProcessed);
        }
        Trace.trace(TRACE_MASKD, "<- getStringArray");
        return bytesProcessed;
    }

    public int parseFruData(long frucount, int offset) {
        Trace.trace(TRACE_MASKD, "->parseFruData");
        Trace.trace(TRACE_MASKD, "frucount =" + frucount);
        Trace.trace(TRACE_MASKD, "offset =" + offset);
        int parsePoint = offset;
        String logicControllingMT = "";
        String logicControllingMS = "";
        String powerControllingMT = "";
        String powerControllingMS = "";
        int i = 0;
        while ((long)i < frucount && parsePoint <= this.getTotalLength()) {
            PIFru fruElement = new PIFru();
            String stringData = ByteArray.extractNullString(this.logData, parsePoint);
            parsePoint += stringData.length() + 1;
            stringData = stringData.trim();
            fruElement.setPartNumber(stringData);
            Trace.trace(TRACE_MASKD, "partnumber " + stringData);
            Trace.trace(TRACE_MASKD, "parsePoint is " + parsePoint);
            logicControllingMS = ByteArray.extractNullString(this.logData, parsePoint);
            parsePoint += logicControllingMS.length() + 1;
            logicControllingMS = logicControllingMS.trim();
            Trace.trace(TRACE_MASKD, "logicControllingMS " + logicControllingMS);
            Trace.trace(TRACE_MASKD, "parsePoint is " + parsePoint);
            logicControllingMT = ByteArray.extractNullString(this.logData, parsePoint);
            parsePoint += logicControllingMT.length() + 1;
            logicControllingMT = logicControllingMT.trim();
            Trace.trace(TRACE_MASKD, "logicControllingMT " + logicControllingMT);
            Trace.trace(TRACE_MASKD, "parsePoint is " + parsePoint);
            fruElement.setLogicControllingSystem(new PASystem(logicControllingMT, "", logicControllingMS));
            powerControllingMS = ByteArray.extractNullString(this.logData, parsePoint);
            parsePoint += powerControllingMS.length() + 1;
            powerControllingMS = powerControllingMS.trim();
            powerControllingMT = ByteArray.extractNullString(this.logData, parsePoint);
            parsePoint += powerControllingMT.length() + 1;
            powerControllingMT = powerControllingMT.trim();
            fruElement.setPowerControllingSystem(new PASystem(powerControllingMT, "", powerControllingMS));
            this.numLocationCodes = (int)ByteArray.extractU32(this.logData, parsePoint, true);
            Trace.trace(TRACE_MASKD, "numLocationCodes =" + this.numLocationCodes);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += 4));
            if (this.numLocationCodes + parsePoint > this.getTotalLength()) {
                Trace.trace(TRACE_MASKD, "numLocationCodes will blow past our length return ");
                return -1;
            }
            this.locationCodes = new String[this.numLocationCodes];
            int len = this.getStringArray(this.logData, parsePoint, this.locationCodes);
            parsePoint += len;
            for (int y = 0; y < this.locationCodes.length; ++y) {
                Trace.trace(TRACE_MASKD, " location[" + y + "] = " + this.locationCodes[y]);
                fruElement.addLocation(this.locationCodes[y]);
            }
            Trace.trace(TRACE_MASKD, "after geting location codes ");
            Trace.trace(TRACE_MASKD, "parsePoint is " + parsePoint);
            String ccin = ByteArray.extractNullString(this.logData, parsePoint);
            parsePoint += ccin.length() + 1;
            ccin = ccin.trim();
            fruElement.setCCIN(ccin);
            Trace.trace(TRACE_MASKD, "ccin " + ccin);
            Trace.trace(TRACE_MASKD, "parsePoint is " + parsePoint);
            String serialNumber = ByteArray.extractNullString(this.logData, parsePoint);
            parsePoint += serialNumber.length() + 1;
            serialNumber = serialNumber.trim();
            fruElement.setSerialNumber(serialNumber);
            long fruClass = ByteArray.extractU32(this.logData, parsePoint, true);
            fruElement.setFruClass((int)fruClass);
            String replaceGroup = ByteArray.extractNullString(this.logData, parsePoint += 4);
            parsePoint += replaceGroup.length() + 1;
            replaceGroup = replaceGroup.trim();
            fruElement.setReplacementGroup(replaceGroup);
            this.addFru(fruElement);
            ++i;
        }
        Trace.trace(TRACE_MASKD, "processed " + (parsePoint - offset) + " bytes");
        return parsePoint - offset;
    }

    public int parseNodeData(long nodecount, int offset) {
        Trace.trace(TRACE_MASKD, "-->parseNodeData(count=" + nodecount + ", offset =" + offset);
        int parsePoint = offset;
        int i = 0;
        while ((long)i < nodecount && parsePoint <= this.getTotalLength()) {
            this.numCecsMT = (int)ByteArray.extractU32(this.logData, parsePoint, true);
            if (this.numCecsMT + (parsePoint += 4) > this.getTotalLength()) {
                Trace.trace(TRACE_MASKD, "numCecsMT will blow past our length return ");
                return -1;
            }
            this.cecMT = new String[this.numCecsMT];
            int len = this.getStringArray(this.logData, parsePoint, this.cecMT);
            Trace.trace(TRACE_MASKD, "numCecsMT " + this.numCecsMT);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += len));
            this.numCecsMS = (int)ByteArray.extractU32(this.logData, parsePoint, true);
            if (this.numCecsMS + (parsePoint += 4) > this.getTotalLength()) {
                Trace.trace(TRACE_MASKD, "numCecsMS will blow past our length return ");
                return -1;
            }
            this.cecMS = new String[this.numCecsMS];
            len = this.getStringArray(this.logData, parsePoint, this.cecMS);
            Trace.trace(TRACE_MASKD, "numCecsMS " + this.numCecsMS);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += len));
            this.devMT = ByteArray.extractNullString(this.logData, parsePoint);
            this.devMT = this.devMT.trim();
            Trace.trace(TRACE_MASKD, "devMT " + this.devMT);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += this.devMT.length() + 1));
            this.devMS = ByteArray.extractNullString(this.logData, parsePoint);
            this.devMS = this.devMS.trim();
            Trace.trace(TRACE_MASKD, "devMS " + this.devMS);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += this.devMS.length() + 1));
            this.aixErrorCode = ByteArray.extractNullString(this.logData, parsePoint);
            this.aixErrorCode = this.aixErrorCode.trim();
            Trace.trace(TRACE_MASKD, "aixErrorCode " + this.aixErrorCode);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += this.aixErrorCode.length() + 1));
            String svcEventText = ByteArray.extractNullString(this.logData, parsePoint);
            this.setSvcEventText(new LocalizableText(svcEventText.trim()));
            this.partitionID = ByteArray.extractNullString(this.logData, parsePoint += svcEventText.length() + 1);
            this.partitionID = this.partitionID.trim();
            this.partitionName = ByteArray.extractNullString(this.logData, parsePoint += this.partitionID.length() + 1);
            this.partitionName = this.partitionName.trim();
            this.partitionHostName = ByteArray.extractNullString(this.logData, parsePoint += this.partitionName.length() + 1);
            this.partitionHostName = this.partitionHostName.trim();
            this.partitionOSType = ByteArray.extractNullString(this.logData, parsePoint += this.partitionHostName.length() + 1);
            this.partitionOSType = this.partitionOSType.trim();
            this.saelFirstReportedTime = ByteArray.extractNullString(this.logData, parsePoint += this.partitionOSType.length() + 1);
            this.saelFirstReportedTime = this.saelFirstReportedTime.trim();
            this.lastSubsystemReportedTime = ByteArray.extractNullString(this.logData, parsePoint += this.saelFirstReportedTime.length() + 1);
            this.lastSubsystemReportedTime = this.lastSubsystemReportedTime.trim();
            Trace.trace(TRACE_MASKD, "lastSubsystemReportedTime " + this.lastSubsystemReportedTime);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += this.lastSubsystemReportedTime.length() + 1));
            this.seqNum = ByteArray.extractU32(this.logData, parsePoint, true);
            Trace.trace(TRACE_MASKD, "seqNum " + this.seqNum);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += 4));
            this.duplicateCount = (int)ByteArray.extractU32(this.logData, parsePoint, true);
            this.eed = ByteArray.extractNullString(this.logData, parsePoint += 4);
            this.eed = this.eed.trim();
            String[] localeList = new String[]{""};
            int numLocales = (int)ByteArray.extractU32(this.logData, parsePoint += this.eed.length() + 1, true);
            Trace.trace(TRACE_MASKD, "numLocales " + numLocales);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += 4));
            if (numLocales + parsePoint > this.getTotalLength()) {
                Trace.trace(TRACE_MASKD, "locales will blow past our length return ");
                return -1;
            }
            localeList = new String[numLocales];
            len = this.getStringArray(this.logData, parsePoint, localeList);
            this.addHMCLocales(localeList);
            String[] messageList = new String[]{""};
            int numMessages = (int)ByteArray.extractU32(this.logData, parsePoint += len, true);
            if (numMessages + (parsePoint += 4) > this.getTotalLength()) {
                Trace.trace(TRACE_MASKD, "numMessages will blow past our length return ");
                return -1;
            }
            messageList = new String[numMessages];
            len = this.getStringArray(this.logData, parsePoint, messageList);
            this.addNLSMessages(messageList);
            this.numClusters = (int)ByteArray.extractU32(this.logData, parsePoint += len, true);
            if (this.numClusters + (parsePoint += 4) > this.getTotalLength()) {
                Trace.trace(TRACE_MASKD, "numClusters will blow past our length return ");
                return -1;
            }
            this.clusterList = new String[this.numClusters];
            len = this.getStringArray(this.logData, parsePoint, this.clusterList);
            this.hpsNetworkID = ByteArray.extractNullString(this.logData, parsePoint += len);
            this.hpsNetworkID = this.hpsNetworkID.trim();
            Trace.trace(TRACE_MASKD, "hpsNetworkID " + this.hpsNetworkID);
            Trace.trace(TRACE_MASKD, "parsePoint is " + (parsePoint += this.hpsNetworkID.length() + 1));
            ++i;
        }
        Trace.trace(TRACE_MASKD, "<--parseNodeData");
        return parsePoint - offset;
    }

    public boolean isError() {
        return true;
    }

    public boolean isRioError() {
        int ssid = this.getSubsystemID();
        if (ssid == 49 || ssid == 54 || ssid == 55) {
            Trace.trace(TRACE_MASKF, "rio error");
            return true;
        }
        Trace.trace(TRACE_MASKF, "not a rio error");
        return false;
    }

    public boolean isSurveillanceError() {
        return this.getSubsystemID() >= 122 && this.getSubsystemID() < 127;
    }

    public boolean isInfo() {
        return false;
    }

    public int getSystemLogId() {
        return this.slid;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCreatorID() {
        return this.creatorID;
    }

    public String getPartitionOSType() {
        return this.partitionOSType;
    }

    public PASystem getClusterSystem() {
        return this.clusterSystem;
    }

    public String getHPSNetworkID() {
        return this.hpsNetworkID;
    }

    public String getAIXErrorCode() {
        return this.aixErrorCode;
    }

    public String getPartitionID() {
        return this.partitionID;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getPartitionHostName() {
        return this.partitionHostName;
    }

    public String getSaelFirstReportedTime() {
        return this.saelFirstReportedTime;
    }

    public String getLastSubsystemReportedTime() {
        return this.lastSubsystemReportedTime;
    }

    public int getDuplicateCount() {
        return this.duplicateCount;
    }

    public String getEED() {
        return this.eed;
    }

    public List getFrus() {
        return this.fruList;
    }

    public long getCalledHome() {
        return this.calledHome;
    }

    public long getVariety() {
        return this.variety;
    }

    public String getPmh() {
        return this.pmh;
    }

    public String getSymptomString() {
        return this.symptomString;
    }

    public List getPanelData() {
        ArrayList<CaptionValuePairing> panelList = new ArrayList<CaptionValuePairing>();
        CaptionValuePairing cvp1 = null;
        cvp1 = this.getPartitionOSType().equals("OS400") ? new CaptionValuePairing(new BaseMessageText("XPA7630"), new NonLocalizablePanelValue(this.getErrorLogLabel())) : new CaptionValuePairing(new BaseMessageText("XPA7630"), new NonLocalizablePanelValue(Integer.toString(this.getSystemLogId())));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7672"), new NonLocalizablePanelValue(this.getVersion()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getNotificationType() != null ? new CaptionValuePairing(new BaseMessageText("XPA7614"), new LocalizablePanelValue(this.getNotificationType())) : new CaptionValuePairing(new BaseMessageText("XPA7614"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7615"), new NonLocalizablePanelValue(Integer.toString(this.getPlatformLogID())));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7622"), new NonLocalizablePanelValue(Integer.toString(this.getEventSeverity())));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7673"), new NonLocalizablePanelValue(this.getCreatorID()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7617"), new NonLocalizablePanelValue(this.getRefcode()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7618"), new NonLocalizablePanelValue(Integer.toString(this.getSubsystemID())));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7644"), new NonLocalizablePanelValue(this.getPartitionOSType()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        if (this.getFailingEnclosureSystem() != null) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7654"), new NonLocalizablePanelValue(this.getFailingEnclosureSystem().getMTMS()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        if (this.getReportingSystem() != null) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7661"), new NonLocalizablePanelValue(this.getReportingSystem().getMTMS()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        if (this.getClusterSystem() != null) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7632"), new NonLocalizablePanelValue(this.getClusterSystem().getMTMS()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7633"), new NonLocalizablePanelValue(this.getHPSNetworkID()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7634"), new NonLocalizablePanelValue(this.getAIXErrorCode()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7635"), new LocalizablePanelValue(this.getSvcEventText()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        Iterator it = this.getHMCLocales().iterator();
        while (it.hasNext()) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7636"), new NonLocalizablePanelValue((String)it.next()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        it = this.getNLSMessages().iterator();
        while (it.hasNext()) {
            cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7637"), new NonLocalizablePanelValue((String)it.next()));
            cvp1.setDisplayMode(1);
            panelList.add(cvp1);
        }
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7638"), new NonLocalizablePanelValue(this.getPartitionID()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7639"), new NonLocalizablePanelValue(this.getPartitionName()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7640"), new NonLocalizablePanelValue(this.getPartitionHostName()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7655"), new NonLocalizablePanelValue(this.getSaelFirstReportedTime()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7641"), new NonLocalizablePanelValue(this.getLastSubsystemReportedTime()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7642"), new NonLocalizablePanelValue(Integer.toString(this.duplicateCount)));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7643"), new NonLocalizablePanelValue(this.getEED()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        return panelList;
    }

    public String getSaelNotificationString() {
        return this.saelNotificationType;
    }

    private String getRioLoopId() {
        String decLoopString = "1668";
        Trace.trace(TRACE_MASKD, "refcode length =  " + this.getRefcode().length());
        String refcode = this.getRefcode();
        if (refcode.length() > 50) {
            String loopId = refcode.substring(48, 52);
            Trace.trace(TRACE_MASKD, "the loop id is " + loopId);
            decLoopString = Integer.valueOf(loopId, 16).toString();
            Trace.trace(TRACE_MASKD, "the decimal value is" + decLoopString);
        }
        return decLoopString;
    }

    public String Oasf(byte[] array, int offset) {
        int nullAt = 0;
        for (int i = 0; i < array.length - offset && array[offset + i] != 0; ++i) {
            ++nullAt;
        }
        if (nullAt == 0) {
            return "";
        }
        Trace.trace(TRACE_MASKD, "nullat " + nullAt);
        return ByteArray.extractString(array, offset, nullAt + 1);
    }

    /*
     * Opcode count of 22452 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void main(String[] args) {
        byte[] saelNew2 = new byte[]{-1, -64, 1, 0, 0, 89, 101, 115, 0, 0, 0, 0, 0, 10, 0, 0, 0, 112, 112, 16, 80, 69, 0, -127, 0, 0, 0, 66, 49, 56, 49, 68, 49, 49, 48, 48, 51, 48, 48, 48, 48, 70, 48, 53, 50, 50, 57, 48, 49, 49, 48, 68, 49, 51, 57, 49, 48, 48, 49, 52, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 48, 48, 48, 48, 48, 52, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 70, 83, 80, 83, 80, 48, 52, 0, 0, 0, 0, 0, 1, 0, 0, 0, 110, 47, 97, 0, 0, 0, 4, 0, 0, 0, 72, 0, 70, 83, 80, 83, 80, 48, 54, 0, 0, 0, 0, 0, 1, 0, 0, 0, 110, 47, 97, 0, 0, 0, 4, 0, 0, 0, 77, 0, 1, 0, 0, 0, 1, 0, 0, 0, 57, 52, 48, 54, 45, 53, 50, 48, 0, 1, 0, 0, 0, 49, 48, 48, 48, 53, 68, 65, 0, 57, 52, 48, 54, 45, 53, 50, 48, 0, 49, 48, 48, 48, 53, 68, 65, 0, 0, 80, 108, 97, 116, 102, 111, 114, 109, 32, 70, 105, 114, 109, 119, 97, 114, 101, 32, 80, 114, 101, 100, 105, 99, 116, 105, 118, 101, 32, 69, 114, 114, 111, 114, 44, 32, 103, 101, 110, 101, 114, 97, 108, 46, 32, 82, 101, 102, 101, 114, 32, 116, 111, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 115, 101, 114, 118, 105, 99, 101, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 46, 0, 48, 48, 50, 0, 101, 110, 100, 115, 113, 100, 48, 52, 0, 101, 110, 100, 115, 113, 100, 48, 52, 0, 65, 73, 88, 0, 48, 53, 47, 48, 52, 47, 50, 48, 48, 52, 32, 49, 51, 58, 50, 48, 58, 49, 52, 0, 48, 53, 47, 48, 52, 47, 50, 48, 48, 52, 32, 49, 51, 58, 50, 48, 58, 49, 52, 0, 6, 26, 0, 0, 0, 0, 0, 0, 47, 116, 109, 112, 47, 100, 105, 97, 103, 83, 69, 103, 101, 110, 83, 110, 97, 112, 47, 115, 110, 97, 112, 72, 46, 112, 97, 120, 46, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] sael231 = new byte[]{-1, -25, 0, 0, 0, 78, 111, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 57, 52, 48, 54, 45, 53, 50, 48, 0, 1, 0, 0, 0, 49, 48, 48, 48, 53, 68, 65, 0, 57, 52, 48, 54, 45, 53, 50, 48, 0, 49, 48, 48, 48, 53, 68, 65, 0, 35, 54, 53, 49, 51, 48, 49, 0, 10, 83, 111, 102, 116, 119, 97, 114, 101, 32, 77, 105, 115, 99, 101, 108, 108, 97, 110, 101, 111, 117, 115, 44, 32, 73, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 79, 110, 108, 121, 46, 10, 10, 0, 48, 48, 50, 0, 101, 110, 100, 115, 113, 100, 48, 52, 0, 101, 110, 100, 115, 113, 100, 48, 52, 0, 65, 73, 88, 0, 48, 52, 47, 48, 57, 47, 50, 48, 48, 52, 32, 48, 48, 58, 49, 51, 58, 53, 55, 0, 48, 52, 47, 48, 57, 47, 50, 48, 48, 52, 32, 48, 48, 58, 49, 51, 58, 53, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0};
        byte[] saelNFP = new byte[]{-1, -81, 1, 0, 0, 89, 101, 115, 0, 0, 0, 0, 0, 10, 0, 0, 0, 20, 12, 0, -126, 87, 0, 96, 0, 0, 0, 49, 48, 48, 48, 57, 49, 49, 69, 48, 48, 48, 48, 48, 48, 52, 48, 49, 48, 48, 48, 48, 50, 49, 67, 48, 48, 48, 48, 70, 68, 49, 69, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 110, 47, 97, 0, 0, 0, 0, 0, 0, 0, 77, 0, 1, 0, 0, 0, 1, 0, 0, 0, 57, 52, 48, 54, 45, 53, 50, 48, 0, 1, 0, 0, 0, 49, 48, 48, 48, 53, 68, 65, 0, 57, 52, 48, 54, 45, 53, 50, 48, 0, 49, 48, 48, 48, 53, 68, 65, 0, 0, 80, 111, 119, 101, 114, 47, 67, 111, 111, 108, 105, 110, 103, 32, 115, 117, 98, 115, 121, 115, 116, 101, 109, 32, 85, 110, 114, 101, 99, 111, 118, 101, 114, 101, 100, 32, 69, 114, 114, 111, 114, 44, 32, 98, 121, 112, 97, 115, 115, 101, 100, 32, 119, 105, 116, 104, 32, 108, 111, 115, 115, 32, 111, 102, 32, 114, 101, 100, 117, 110, 100, 97, 110, 99, 121, 32, 97, 110, 100, 32, 112, 101, 114, 102, 111, 114, 109, 97, 110, 99, 101, 46, 32, 82, 101, 102, 101, 114, 32, 116, 111, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 115, 101, 114, 118, 105, 99, 101, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 46, 0, 48, 48, 50, 0, 101, 110, 100, 115, 113, 100, 48, 52, 0, 101, 110, 100, 115, 113, 100, 48, 52, 0, 65, 73, 88, 0, 48, 52, 47, 48, 57, 47, 50, 48, 48, 52, 32, 48, 48, 58, 49, 54, 58, 49, 50, 0, 48, 52, 47, 48, 57, 47, 50, 48, 48, 52, 32, 48, 48, 58, 49, 54, 58, 49, 50, 0, 8, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0};
        byte[] saelData = new byte[]{-1, 81, 3, 0, 0, 121, 101, 115, 0, 1, 0, 0, 0, 12, 0, 0, 0, 50, 84, 0, 0, 83, 97, 109, 32, 73, 32, 97, 109, 0, 65, 0, 0, 0, 66, 49, 48, 55, 48, 55, 54, 49, 0, 5, 0, 0, 0, 2, 0, 0, 0, 110, 97, 109, 101, 43, 115, 116, 97, 116, 0, 101, 109, 97, 110, 43, 116, 97, 116, 115, 0, 97, 98, 99, 0, 2, 0, 0, 0, 112, 97, 114, 116, 32, 110, 117, 109, 98, 101, 114, 49, 0, 108, 111, 103, 105, 99, 109, 115, 49, 0, 108, 111, 105, 103, 99, 109, 116, 49, 0, 32, 112, 111, 119, 101, 114, 109, 115, 49, 0, 112, 111, 119, 101, 114, 109, 116, 49, 0, 2, 0, 0, 0, 108, 111, 99, 32, 99, 111, 100, 101, 32, 49, 0, 108, 111, 99, 32, 99, 111, 100, 101, 32, 50, 0, 99, 99, 105, 110, 49, 0, 115, 101, 114, 105, 97, 108, 110, 117, 109, 49, 0, 4, 0, 0, 0, 103, 114, 111, 117, 112, 49, 0, 112, 97, 114, 116, 32, 110, 117, 109, 98, 101, 114, 50, 0, 108, 111, 103, 105, 99, 109, 115, 50, 0, 108, 111, 103, 105, 99, 109, 116, 50, 0, 32, 112, 111, 119, 101, 114, 109, 115, 50, 0, 112, 111, 119, 101, 114, 109, 116, 50, 0, 2, 0, 0, 0, 108, 111, 99, 32, 99, 111, 100, 101, 32, 51, 0, 108, 111, 99, 32, 99, 111, 100, 101, 32, 52, 0, 99, 99, 105, 110, 50, 0, 115, 101, 114, 105, 97, 108, 110, 117, 109, 50, 0, 5, 0, 0, 0, 103, 114, 111, 117, 112, 50, 0, 2, 0, 0, 0, 3, 0, 0, 0, 99, 109, 116, 109, 115, 49, 0, 99, 109, 116, 109, 115, 50, 0, 99, 109, 116, 109, 115, 51, 0, 3, 0, 0, 0, 99, 101, 99, 109, 115, 49, 0, 99, 101, 99, 109, 115, 50, 0, 99, 101, 99, 109, 115, 51, 0, 68, 69, 86, 32, 77, 84, 49, 0, 68, 69, 86, 32, 77, 83, 49, 0, 112, 69, 114, 114, 111, 114, 67, 111, 100, 101, 49, 0, 112, 69, 114, 114, 111, 114, 84, 101, 120, 116, 49, 0, 112, 80, 97, 114, 116, 105, 116, 105, 111, 110, 73, 68, 49, 0, 112, 80, 97, 114, 116, 105, 116, 105, 111, 110, 78, 97, 109, 101, 49, 0, 112, 72, 111, 115, 116, 78, 97, 109, 101, 49, 0, 112, 79, 83, 84, 121, 112, 101, 49, 0, 112, 79, 114, 105, 103, 84, 105, 109, 101, 83, 116, 97, 109, 112, 49, 0, 112, 76, 97, 115, 116, 84, 105, 109, 101, 83, 116, 97, 109, 112, 49, 0, 1, 0, 0, 0, 2, 0, 0, 0, 112, 76, 111, 99, 97, 108, 69, 69, 68, 49, 0, 2, 0, 0, 0, 108, 111, 99, 97, 108, 101, 32, 49, 49, 49, 0, 108, 111, 99, 97, 108, 101, 32, 50, 50, 50, 0, 2, 0, 0, 0, 109, 101, 115, 115, 97, 103, 101, 32, 49, 49, 0, 109, 101, 115, 115, 97, 103, 101, 32, 49, 50, 0, 2, 0, 0, 0, 99, 108, 117, 115, 116, 101, 114, 32, 49, 49, 0, 99, 108, 117, 115, 116, 101, 114, 32, 50, 50, 0, 70, 69, 68, 32, 105, 100, 32, 49, 0, 3, 0, 0, 0, 99, 109, 116, 109, 115, 57, 0, 99, 109, 116, 109, 115, 56, 0, 99, 109, 116, 109, 115, 55, 0, 3, 0, 0, 0, 99, 101, 99, 109, 115, 57, 0, 99, 101, 99, 109, 115, 56, 0, 99, 101, 99, 109, 115, 55, 0, 68, 69, 86, 32, 77, 84, 57, 0, 68, 69, 86, 32, 77, 83, 56, 0, 112, 69, 114, 114, 111, 114, 67, 111, 100, 101, 50, 0, 112, 69, 114, 114, 111, 114, 84, 101, 120, 116, 50, 0, 112, 80, 97, 114, 116, 105, 116, 105, 111, 110, 73, 68, 50, 0, 112, 80, 97, 114, 116, 105, 116, 105, 111, 110, 78, 97, 109, 101, 50, 0, 112, 72, 111, 115, 116, 78, 97, 109, 101, 50, 0, 112, 79, 83, 84, 121, 112, 101, 50, 0, 112, 79, 114, 105, 103, 84, 105, 109, 101, 83, 116, 97, 109, 112, 50, 0, 112, 76, 97, 115, 116, 84, 105, 109, 101, 83, 116, 97, 109, 112, 50, 0, 1, 0, 0, 0, 2, 0, 0, 0, 112, 76, 111, 99, 97, 108, 69, 69, 68, 50, 0, 2, 0, 0, 0, 108, 111, 99, 97, 108, 101, 32, 57, 57, 57, 0, 108, 111, 99, 97, 108, 101, 32, 56, 56, 56, 0, 2, 0, 0, 0, 109, 101, 115, 115, 97, 103, 101, 32, 50, 49, 0, 109, 101, 115, 115, 97, 103, 101, 32, 50, 50, 0, 2, 0, 0, 0, 99, 108, 117, 115, 116, 101, 114, 32, 55, 55, 0, 99, 108, 117, 115, 116, 101, 114, 32, 56, 56, 0, 70, 69, 68, 32, 105, 100, 32, 50, 0, 0, 0};
        byte[] saelData2 = new byte[]{-1, 39, 13, 0, 0, 89, 101, 115, 0, 0, 0, 0, 0, 10, 0, 0, 0, 1, 0, 0, 0, 67, 114, 101, 97, 116, 111, 114, 32, 73, 68, 0, 2, 0, 0, 0, 83, 121, 115, 116, 101, 109, 82, 101, 102, 67, 111, 100, 101, 0, 3, 0, 0, 0, 4, 0, 0, 0, 70, 105, 120, 80, 97, 99, 107, 97, 103, 101, 49, 0, 70, 105, 120, 80, 97, 99, 107, 97, 103, 101, 83, 116, 97, 116, 117, 115, 49, 0, 70, 105, 120, 80, 97, 99, 107, 97, 103, 101, 50, 0, 70, 105, 120, 80, 97, 99, 107, 97, 103, 101, 83, 116, 97, 116, 117, 115, 50, 0, 80, 72, 77, 78, 117, 109, 98, 101, 114, 0, 3, 0, 0, 0, 70, 82, 85, 76, 95, 112, 97, 114, 116, 110, 117, 109, 49, 0, 76, 79, 71, 67, 84, 76, 95, 77, 83, 0, 76, 79, 71, 67, 84, 76, 95, 77, 84, 0, 80, 79, 87, 67, 84, 76, 95, 77, 83, 0, 80, 79, 87, 67, 84, 76, 95, 77, 84, 0, 3, 0, 0, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 49, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 50, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 51, 0, 67, 67, 73, 78, 0, 70, 82, 85, 76, 95, 83, 78, 95, 48, 48, 48, 49, 0, 0, 0, 0, 0, 82, 101, 112, 108, 97, 99, 101, 109, 101, 110, 116, 71, 114, 111, 117, 112, 48, 0, 70, 82, 85, 76, 95, 112, 97, 114, 116, 110, 117, 109, 49, 98, 0, 76, 79, 71, 67, 84, 76, 95, 77, 83, 98, 0, 76, 79, 71, 67, 84, 76, 95, 77, 84, 98, 0, 80, 79, 87, 67, 84, 76, 95, 77, 83, 98, 0, 80, 79, 87, 67, 84, 76, 95, 77, 84, 98, 0, 3, 0, 0, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 49, 98, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 50, 98, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 51, 98, 0, 67, 67, 73, 78, 98, 0, 70, 82, 85, 76, 95, 83, 78, 95, 48, 48, 48, 49, 98, 0, 1, 0, 0, 0, 82, 101, 112, 108, 97, 99, 101, 109, 101, 110, 116, 71, 114, 111, 117, 112, 49, 0, 70, 82, 85, 76, 95, 112, 97, 114, 116, 110, 117, 109, 49, 99, 0, 76, 79, 71, 67, 84, 76, 95, 77, 83, 99, 0, 76, 79, 71, 67, 84, 76, 95, 77, 84, 99, 0, 80, 79, 87, 67, 84, 76, 95, 77, 83, 99, 0, 80, 79, 87, 67, 84, 76, 95, 77, 84, 99, 0, 3, 0, 0, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 49, 99, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 50, 99, 0, 70, 82, 85, 76, 95, 108, 111, 99, 118, 51, 95, 48, 48, 51, 99, 0, 67, 67, 73, 78, 99, 0, 70, 82, 85, 76, 95, 83, 78, 95, 48, 48, 48, 49, 99, 0, 2, 0, 0, 0, 82, 101, 112, 108, 97, 99, 101, 109, 101, 110, 116, 71, 114, 111, 117, 112, 50, 0, 1, 0, 0, 0, 2, 0, 0, 0, 55, 48, 51, 56, 45, 54, 77, 50, 0, 88, 88, 88, 88, 45, 88, 88, 88, 0, 2, 0, 0, 0, 49, 48, 65, 65, 68, 56, 68, 0, 89, 89, 89, 89, 45, 89, 89, 89, 0, 55, 48, 51, 56, 45, 54, 77, 50, 0, 49, 48, 65, 65, 68, 56, 68, 0, 66, 67, 54, 48, 32, 48, 48, 49, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 70, 49, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 49, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 32, 48, 48, 48, 48, 0, 84, 104, 101, 32, 102, 114, 97, 109, 101, 32, 112, 111, 119, 101, 114, 32, 115, 117, 98, 115, 121, 115, 116, 101, 109, 32, 114, 101, 112, 111, 114, 116, 101, 100, 32, 97, 32, 99, 114, 105, 116, 105, 99, 97, 108, 32, 101, 110, 118, 105, 114, 111, 110, 109, 101, 110, 116, 97, 108, 32, 101, 114, 114, 111, 114, 32, 119, 105, 116, 104, 105, 110, 32, 97, 32, 115, 119, 105, 116, 99, 104, 32, 99, 97, 103, 101, 46, 32, 82, 101, 112, 111, 114, 116, 32, 116, 104, 101, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 97, 110, 100, 32, 112, 104, 121, 115, 105, 99, 97, 108, 32, 108, 111, 99, 97, 116, 105, 111, 110, 32, 99, 111, 100, 101, 115, 32, 116, 111, 32, 121, 111, 117, 114, 32, 115, 101, 114, 118, 105, 99, 101, 32, 112, 114, 111, 118, 105, 100, 101, 114, 46, 0, 110, 47, 97, 0, 110, 47, 97, 0, 110, 47, 97, 0, 76, 105, 110, 117, 120, 0, 49, 47, 50, 53, 47, 50, 48, 48, 52, 32, 48, 50, 58, 48, 50, 58, 49, 48, 0, 50, 47, 48, 49, 47, 50, 48, 48, 52, 32, 48, 50, 58, 49, 49, 58, 49, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 118, 97, 114, 47, 104, 115, 99, 47, 108, 111, 103, 47, 66, 66, 47, 101, 101, 100, 46, 102, 105, 108, 101, 49, 0, 8, 0, 0, 0, 100, 101, 95, 68, 69, 0, 101, 115, 95, 69, 83, 0, 102, 114, 95, 70, 82, 0, 104, 117, 95, 72, 85, 0, 106, 97, 95, 74, 80, 0, 105, 116, 95, 73, 84, 0, 114, 117, 95, 82, 85, 0, 115, 107, 95, 83, 75, 0, 8, 0, 0, 0, 84, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 104, 97, 115, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 117, 115, 101, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 101, 120, 99, 101, 101, 100, 105, 110, 103, 32, 116, 104, 101, 32, 97, 109, 111, 117, 110, 116, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 46, 32, 32, 73, 109, 109, 101, 100, 105, 97, 116, 101, 108, 121, 32, 114, 101, 116, 117, 114, 110, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 108, 101, 118, 101, 108, 32, 102, 111, 114, 32, 119, 104, 105, 99, 104, 32, 121, 111, 117, 32, 104, 97, 118, 101, 32, 97, 99, 113, 117, 105, 114, 101, 100, 32, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 46, 32, 32, 67, 111, 110, 115, 117, 108, 116, 32, 116, 104, 101, 32, 67, 97, 112, 97, 99, 105, 116, 121, 32, 85, 112, 103, 114, 97, 100, 101, 32, 79, 110, 32, 68, 101, 109, 97, 110, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 100, 101, 116, 97, 105, 108, 101, 100, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 0, 84, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 104, 97, 115, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 117, 115, 101, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 101, 120, 99, 101, 101, 100, 105, 110, 103, 32, 116, 104, 101, 32, 97, 109, 111, 117, 110, 116, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 46, 32, 32, 73, 109, 109, 101, 100, 105, 97, 116, 101, 108, 121, 32, 114, 101, 116, 117, 114, 110, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 108, 101, 118, 101, 108, 32, 102, 111, 114, 32, 119, 104, 105, 99, 104, 32, 121, 111, 117, 32, 104, 97, 118, 101, 32, 97, 99, 113, 117, 105, 114, 101, 100, 32, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 46, 32, 32, 67, 111, 110, 115, 117, 108, 116, 32, 116, 104, 101, 32, 67, 97, 112, 97, 99, 105, 116, 121, 32, 85, 112, 103, 114, 97, 100, 101, 32, 79, 110, 32, 68, 101, 109, 97, 110, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 100, 101, 116, 97, 105, 108, 101, 100, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 0, 84, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 104, 97, 115, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 117, 115, 101, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 101, 120, 99, 101, 101, 100, 105, 110, 103, 32, 116, 104, 101, 32, 97, 109, 111, 117, 110, 116, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 46, 32, 32, 73, 109, 109, 101, 100, 105, 97, 116, 101, 108, 121, 32, 114, 101, 116, 117, 114, 110, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 108, 101, 118, 101, 108, 32, 102, 111, 114, 32, 119, 104, 105, 99, 104, 32, 121, 111, 117, 32, 104, 97, 118, 101, 32, 97, 99, 113, 117, 105, 114, 101, 100, 32, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 46, 32, 32, 67, 111, 110, 115, 117, 108, 116, 32, 116, 104, 101, 32, 67, 97, 112, 97, 99, 105, 116, 121, 32, 85, 112, 103, 114, 97, 100, 101, 32, 79, 110, 32, 68, 101, 109, 97, 110, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 100, 101, 116, 97, 105, 108, 101, 100, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 0, 84, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 104, 97, 115, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 117, 115, 101, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 101, 120, 99, 101, 101, 100, 105, 110, 103, 32, 116, 104, 101, 32, 97, 109, 111, 117, 110, 116, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 46, 32, 32, 73, 109, 109, 101, 100, 105, 97, 116, 101, 108, 121, 32, 114, 101, 116, 117, 114, 110, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 108, 101, 118, 101, 108, 32, 102, 111, 114, 32, 119, 104, 105, 99, 104, 32, 121, 111, 117, 32, 104, 97, 118, 101, 32, 97, 99, 113, 117, 105, 114, 101, 100, 32, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 46, 32, 32, 67, 111, 110, 115, 117, 108, 116, 32, 116, 104, 101, 32, 67, 97, 112, 97, 99, 105, 116, 121, 32, 85, 112, 103, 114, 97, 100, 101, 32, 79, 110, 32, 68, 101, 109, 97, 110, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 100, 101, 116, 97, 105, 108, 101, 100, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 0, 84, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 104, 97, 115, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 117, 115, 101, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 101, 120, 99, 101, 101, 100, 105, 110, 103, 32, 116, 104, 101, 32, 97, 109, 111, 117, 110, 116, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 46, 32, 32, 73, 109, 109, 101, 100, 105, 97, 116, 101, 108, 121, 32, 114, 101, 116, 117, 114, 110, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 108, 101, 118, 101, 108, 32, 102, 111, 114, 32, 119, 104, 105, 99, 104, 32, 121, 111, 117, 32, 104, 97, 118, 101, 32, 97, 99, 113, 117, 105, 114, 101, 100, 32, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 46, 32, 32, 67, 111, 110, 115, 117, 108, 116, 32, 116, 104, 101, 32, 67, 97, 112, 97, 99, 105, 116, 121, 32, 85, 112, 103, 114, 97, 100, 101, 32, 79, 110, 32, 68, 101, 109, 97, 110, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 100, 101, 116, 97, 105, 108, 101, 100, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 0, 84, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 104, 97, 115, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 117, 115, 101, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 101, 120, 99, 101, 101, 100, 105, 110, 103, 32, 116, 104, 101, 32, 97, 109, 111, 117, 110, 116, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 46, 32, 32, 73, 109, 109, 101, 100, 105, 97, 116, 101, 108, 121, 32, 114, 101, 116, 117, 114, 110, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 108, 101, 118, 101, 108, 32, 102, 111, 114, 32, 119, 104, 105, 99, 104, 32, 121, 111, 117, 32, 104, 97, 118, 101, 32, 97, 99, 113, 117, 105, 114, 101, 100, 32, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 46, 32, 32, 67, 111, 110, 115, 117, 108, 116, 32, 116, 104, 101, 32, 67, 97, 112, 97, 99, 105, 116, 121, 32, 85, 112, 103, 114, 97, 100, 101, 32, 79, 110, 32, 68, 101, 109, 97, 110, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 100, 101, 116, 97, 105, 108, 101, 100, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 0, 84, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 104, 97, 115, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 117, 115, 101, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 101, 120, 99, 101, 101, 100, 105, 110, 103, 32, 116, 104, 101, 32, 97, 109, 111, 117, 110, 116, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 46, 32, 32, 73, 109, 109, 101, 100, 105, 97, 116, 101, 108, 121, 32, 114, 101, 116, 117, 114, 110, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 108, 101, 118, 101, 108, 32, 102, 111, 114, 32, 119, 104, 105, 99, 104, 32, 121, 111, 117, 32, 104, 97, 118, 101, 32, 97, 99, 113, 117, 105, 114, 101, 100, 32, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 46, 32, 32, 67, 111, 110, 115, 117, 108, 116, 32, 116, 104, 101, 32, 67, 97, 112, 97, 99, 105, 116, 121, 32, 85, 112, 103, 114, 97, 100, 101, 32, 79, 110, 32, 68, 101, 109, 97, 110, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 100, 101, 116, 97, 105, 108, 101, 100, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 0, 84, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 104, 97, 115, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 117, 115, 101, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 101, 120, 99, 101, 101, 100, 105, 110, 103, 32, 116, 104, 101, 32, 97, 109, 111, 117, 110, 116, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 46, 32, 32, 73, 109, 109, 101, 100, 105, 97, 116, 101, 108, 121, 32, 114, 101, 116, 117, 114, 110, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 99, 97, 112, 97, 99, 105, 116, 121, 32, 108, 101, 118, 101, 108, 32, 102, 111, 114, 32, 119, 104, 105, 99, 104, 32, 121, 111, 117, 32, 104, 97, 118, 101, 32, 97, 99, 113, 117, 105, 114, 101, 100, 32, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 46, 32, 32, 67, 111, 110, 115, 117, 108, 116, 32, 116, 104, 101, 32, 67, 97, 112, 97, 99, 105, 116, 121, 32, 85, 112, 103, 114, 97, 100, 101, 32, 79, 110, 32, 68, 101, 109, 97, 110, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 102, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 100, 101, 116, 97, 105, 108, 101, 100, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 0, 4, 0, 0, 0, 67, 76, 85, 83, 49, 32, 77, 84, 77, 0, 67, 76, 85, 83, 49, 32, 83, 69, 82, 73, 65, 76, 0, 67, 76, 85, 83, 50, 32, 77, 84, 77, 0, 67, 76, 85, 83, 50, 32, 83, 69, 82, 73, 65, 76, 0, 48, 0, 0};
        byte[] saelNew = new byte[]{-1, 5, 1, 0, 0, 78, 111, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 57, 52, 48, 54, 45, 53, 50, 48, 0, 1, 0, 0, 0, 49, 48, 48, 48, 53, 68, 65, 0, 57, 52, 48, 54, 45, 53, 50, 48, 0, 49, 48, 48, 48, 53, 68, 65, 0, 35, 54, 53, 49, 51, 48, 49, 0, 10, 83, 111, 102, 116, 119, 97, 114, 101, 32, 77, 105, 115, 99, 101, 108, 108, 97, 110, 101, 111, 117, 115, 44, 32, 73, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 79, 110, 108, 121, 46, 10, 10, 0, 48, 48, 50, 0, 101, 110, 100, 115, 113, 100, 48, 52, 0, 101, 110, 100, 115, 113, 100, 48, 52, 0, 65, 73, 88, 0, 48, 52, 47, 50, 57, 47, 50, 48, 48, 52, 32, 49, 54, 58, 48, 49, 58, 53, 52, 0, 48, 52, 47, 50, 57, 47, 50, 48, 48, 52, 32, 49, 54, 58, 48, 49, 58, 53, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 116, 109, 112, 47, 100, 105, 97, 103, 83, 69, 103, 101, 110, 83, 110, 97, 112, 47, 115, 110, 97, 112, 72, 46, 112, 97, 120, 46, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        SaelDataEvent sael = new SaelDataEvent(new Object());
        System.out.println("args length = " + args.length + "parms[0]=" + args[0]);
        if (args[0].length() > 0) {
            if (args[0].equals("saelData2")) {
                sael.setData(saelData2);
            }
            if (args[0].equals("saelData")) {
                sael.setData(saelData);
            }
            if (args[0].equals("saelNFP")) {
                sael.setData(saelNFP);
            }
            if (args[0].equals("sael231")) {
                sael.setData(sael231);
            }
            if (args[0].equals("saelNew")) {
                sael.setData(saelNew);
            }
            if (args[0].equals("saelNew2")) {
                sael.setData(saelNew2);
            }
        } else {
            sael.setData(saelNFP);
        }
        String rioLoopId = sael.getRioLoopId();
        Trace.trace(TRACE_MASKD, "the rio loopid is " + rioLoopId);
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(int i) {
        this.totalLength = i;
    }

    public long timeStringToLong(String time) {
        if (time.equals("")) {
            return 0L;
        }
        int year = Integer.parseInt(time.substring(time.lastIndexOf(47) + 1, time.lastIndexOf(47) + 5));
        int month = Integer.parseInt(time.substring(0, time.indexOf(47)));
        int day = Integer.parseInt(time.substring(time.indexOf(47) + 1, time.indexOf(47) + 3));
        int hour = Integer.parseInt(time.substring(time.indexOf(32) + 1, time.indexOf(32) + 3));
        int min = Integer.parseInt(time.substring(time.indexOf(58) + 1, time.indexOf(58) + 3));
        int sec = Integer.parseInt(time.substring(time.lastIndexOf(58) + 1, time.lastIndexOf(58) + 3));
        int hun = 0;
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, min, sec);
        return cal.getTimeInMillis() + (long)(hun * 10);
    }

    public String getErrorLogLabel() {
        return this.errorLogLabel;
    }

    public void setErrorLogLabel(String string) {
        this.errorLogLabel = string;
    }
}

